/**
 * Beschrijft een cowboypersonage van een computergame.
 * 
 * @author Dominiek Vandewalle
 * @version 2016-04-12
 */
public class Cowboy
{
    //velden
    private String naam;
    private int aantalLevens;
    private int gezondheid;
    
    /**
     * Constructor voor objecten van de klasse Cowboy.
     * @param   naam    De naam van de cowboy.
     */
    public Cowboy(String naam)
    {
        this.naam = naam;
        aantalLevens = 3;
        gezondheid = 100;
    }
    
    /**
     * Methode om op een indiaan te schieten.
     * @param   tegenstander    De indiaan die beschoten wordt
     */
    public void schiet(Indiaan tegenstander)
    {
        if(gezondheid > 0)
        {
           tegenstander.geraakt();
        }
    }
    
    /**
     * Methode vermindert de gezondheidstoestand van de 
     * cowboy met 40 procent. De cowboy verliest een leven 
     * indien de gezondheidstoestand op nul staat en de 
     * cowboy nog levens heeft.
     */    
    public void geraakt()
    {
        gezondheid = Math.max(0, gezondheid - 40);
        
        if(gezondheid == 0 && aantalLevens > 0)
        {
            aantalLevens--;
            gezondheid = 100;
        }
    }
    
    /**
     * Whisky drinken is slecht voor de gezondheid.
     */
    public void drinkWhiskey()
    {
        if(gezondheid != 0)
        {
            geraakt();
        }
    }
    
    /**
     * Toont de gezondheidsstatus van de cowboy in het terminalvenster.
     */
    public void printInfo()
    {
        System.out.println("Ik ben een cowboy van het Westen");
        System.out.println("Naam: " + naam);
        System.out.println("Levens: " + aantalLevens);
        System.out.println("Gezondheid: " + gezondheid);
    }
}